﻿using System;
using System.Collections.Generic;
using System.IO;

namespace memoQSampleCMSConnector
{
	internal class CMS_Session
	{
		internal static Dictionary<string, TranslatableAsset> GetTranslatableContent()
		{
			switch (ConfigurationHelper.Config.mode)
			{
				case Mode.Virtual:
					return CMS_Session_Virtual.GetTranslatableContent();
				case Mode.Jira:
					return CMS_Session_Jira.GetTranslatableContent();
				default:
					return new Dictionary<string, TranslatableAsset>() { };
			}
		}

		internal static void DeliverTranslations(Dictionary<string, Stream> downloadedFiles)
		{
			switch (ConfigurationHelper.Config.mode)
			{
				case Mode.Virtual:
					CMS_Session_Virtual.DeliverTranslations(downloadedFiles);
					break;
				case Mode.Jira:
					CMS_Session_Jira.DeliverTranslations(downloadedFiles);
					break;
				default:
					return;
			}
		}
	}
}